///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 1999-2005 Siebel Systems, Inc.  All rights reserved.
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// SubQueryFilterEditor
///////////////////////////////////////////////////////////////////////////////

//-------------------
function SubQueryFilterEditor(eid)
{
	this.form = document.getElementById(eid + "Form");
	if (this.form == null)
		alert('SubQuery Filter Editor Template not found on page.  ID = ' + eid + 'Form');
}

SubQueryFilterEditor.prototype = new XUIEditor();

//-------------------
// Set the operators into an associative array.  Singleton that sets opArray
SubQueryFilterEditor.initializeOperatorList = function()
{
	if (SubQueryFilterEditor.opArray == undefined)
	{
		var a = new Array;

		a['equal'] = {op:'equal', xsiType:'saw:subQuery', display:kmsgFilterUISubQueryEQANY};

		a['notEqual'] = {op:'notEqual', xsiType:'saw:subQuery', display:kmsgFilterUISubQueryNEQANY};

		a['lessAny'] = {op:'lessAny', xsiType:'saw:subQuery', display:kmsgFilterUISubQueryLTANY};

		a['greaterAny'] = {op:'greaterAny', xsiType:'saw:subQuery', display:kmsgFilterUISubQueryGTANY};

		a['lessAll'] = {op:'lessAll', xsiType:'saw:subQuery', display:kmsgFilterUISubQueryLTALL};

		a['greaterAll'] = {op:'greaterAll', xsiType:'saw:subQuery', display:kmsgFilterUISubQueryGTALL};

		a['lessOrEqualAny'] = {op:'lessOrEqualAny', xsiType:'saw:subQuery', display:kmsgFilterUISubQueryLEANY};

		a['greaterOrEqualAny'] = {op:'greaterOrEqualAny', xsiType:'saw:subQuery', display:kmsgFilterUISubQueryGEANY};

		a['lessOrEqualAll'] = {op:'lessOrEqualAll', xsiType:'saw:subQuery', display:kmsgFilterUISubQueryLEALL};

		a['greaterOrEqualAll'] = {op:'greaterOrEqualAll', xsiType:'saw:subQuery', display:kmsgFilterUISubQueryGEALL};

		SubQueryFilterEditor.opArray = a;
	}
}

SubQueryFilterEditor.prototype.createColumnRef = function(sPath, sColumnID)
{
   var t = XUICreateElement(saw.xml.kSawNamespace, 'columnRef');
   t.setAttribute("path", sPath);
   t.setAttribute("columnID", sColumnID);

	return t;
}

//-------------------
// xmlElement is the expr to edit or create.  It should have a formula when
// called.
SubQueryFilterEditor.prototype.load = function(xmlElement, criteriaElement)
{
	XUICheckNodeName("SubQueryFilterEditor.prototype.load", xmlElement, "sawx:expr", "saw:subQuery");
	XUICheckNodeName("SubQueryFilterEditor.prototype.load", criteriaElement, "saw:criteria");

	this.element = xmlElement;
	this.criteria = criteriaElement;
	this.sqlFormula = xmlElement.selectSingleNode('sawx:expr');

	XUICheckNodeName("SubQueryFilterEditor.prototype.load", this.sqlFormula, "sawx:expr", "sawx:sqlExpression");

	var sFormula = XUIGetElementText(this.sqlFormula);
	this.form.Formula.value = sFormula;

	SubQueryFilterEditor.initializeOperatorList();

	// find the corresponding columnspace
	var tInfo = XUIColumnSpace.findInfo(null, sFormula);

   this.category = tInfo != null ? XUIColumnSpace.getInfoSQLAttr(tInfo, "category") : "unknown";
	//this.primaryType = tInfo != null ? XUIColumnSpace.getInfoSQLAttr(tInfo, "primaryType") : "unknown";
   //this.aggType = tInfo != null ? XUIColumnSpace.getInfoSQLAttr(tInfo, "aggType") : "unknown";

	// show the column being edited
	var sTableHdg = XUIColumnSpace.getInfoHeading(tInfo, "saw:tableHeading");

   
	if (sTableHdg == "")
		sTableHdg = XUIColumn.getTableHeadingFromFormula(sFormula);
	var sColumnHdg = XUIColumnSpace.getInfoHeading(tInfo, "saw:columnHeading");
	if (sColumnHdg == "")
		sColumnHdg = XUIColumn.getColumnHeadingFromFormula(sFormula);

	document.getElementById('idSubQueryFilterColumnName').innerHTML = sTableHdg + "." + sColumnHdg;

	// Add only the operators that apply as options
	var tOptions = this.form.Operator.options;
	var sCurrentOp = this.element.getAttribute("op");
	if (sCurrentOp == "equal")
	   sCurrentOp = "in";

	tOptions.length = 0;
	for (op in SubQueryFilterEditor.opArray)
	{
		var tProps = SubQueryFilterEditor.opArray[op];
		if (!tProps.textOnly || (this.category == "text") || (this.category == "unknown"))
		{
			var tNew = new Option(tProps.display, op);
			tOptions[tOptions.length] = tNew;
			tNew.selected = (op == sCurrentOp);
		}
	}

	//fill in path and get columns
	var tColumnRef = xmlElement.selectSingleNode("saw:columnRef");
	if (tColumnRef)
	{
	   this.form.Path.value = tColumnRef.getAttribute("path");
	   this.columnID = tColumnRef.getAttribute("columnID");
	   this.applyBrowser();
	}
	else
	{
	   this.form.Path.value = "";
	   this.form.SubQueryColumn.options.length = 0;
	}
}

//-------------------
SubQueryFilterEditor.prototype.apply = function()
{
   var sPath = this.form.Path.value;
   if (this.form.SubQueryColumn.options.length > 0)
   {
      var sColumnID = this.form.SubQueryColumn.options[this.form.SubQueryColumn.selectedIndex].value;
      if (sPath && sColumnID)
      {
         this.element.setAttribute("op", this.form.Operator.options[this.form.Operator.selectedIndex].value);
         var txv = this.element.firstChild;
	      if (txv != null)
	      {
	         txv = txv.nextSibling;
	         while (txv != null)
	         {
	            var temp = txv.nextSibling;
	            this.element.removeChild(txv);
	            txv = temp;
	         }
      	}

	      var tFieldExpr = XUIForceSingleNode(this.element, saw.xml.kSawNamespace, 'columnRef');
	      tFieldExpr.setAttribute("path", sPath);
	      tFieldExpr.setAttribute("columnID", sColumnID);
     	   return true;
     	}
   }
   alert(kmsgFilterDisplaySubQueryNoColumns);
   return false;

}

//-------------------
SubQueryFilterEditor.prototype.onChildApply = function(source)
{
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

SubQueryFilterEditor.onChangeOperator = function(eid)
{
}


SubQueryFilterEditor.onChangeSubQueryColumn = function(eid)
{
}

/*************************************************/
//code for loading picker browser
SubQueryFilterEditor.onBrowseDestination = function(eid)
{
   var tEditor = XUIPanel.getEditor(eid);

   //create xml def
   var tCBDef = CatalogBrowser.createDefaultDef(eid);
   tCBDef.setTarget("Path", true);
   tCBDef.setTitle("kmsgChooseReport");
   tCBDef.setTargetCaption("kmsgBrowserItemReport");
   tCBDef.setCommand("LoadPickerBrowser");

   tCBDef.setDashboards("kmsgDashboardAndReportPickerTreeDefXml");
   tCBDef.setPersonalFolder("kmsgCatalogReportPickerTreeDefXml");
   tCBDef.setSharedFolders("kmsgCatalogReportPickerTreeDefXml");

	CatalogBrowser.openBrowser(eid, saw.hooks.CustomizeCBDef(tCBDef, "selectSubquery"));
	return false;
}

//-------------------
SubQueryFilterEditor.prototype.getDisplayPath = function(sPath)
{
   return sPath;
}

//-------------------
SubQueryFilterEditor.prototype.applyBrowser = function(eid)
{
   this.form.SubQueryColumn.options.length = 0;

   var req = new sawr.serverRequest("GetReportColumnsXML", SubQueryFilterEditor.loadSubqueryColumns);
 	req.setFatalErrorHandler(SubQueryFilterEditor.handleServerError);
   req.setCallerObj(this);
   
   var conn = new sawr.xhrConnection(req);
   conn.postForm(this.form);

   //make sure div is there.
	if (document.getElementById("idBrowserDiv") && document.getElementById("idBrowserDiv").style.display != "none")
	{
	   var tBrowser = XUIPanel.getEditor("idBrowser");
      tBrowser.panel.close();
   }
	return false;
}

SubQueryFilterEditor.handleServerError = function(tData, aFatal)
{
   if (aFatal && aFatal.length)  
   {
      for (var i=0; i<aFatal.length; i++)
      {
         alert(aFatal[i].getType() + " : " + aFatal[i].getMessage());
      } 
   }
   else
      alert(kmsgFilterEditorSubQueryFilterColumnInfoError);
}

//-------------------
SubQueryFilterEditor.loadSubqueryColumns = function(tData)
{
   var tEditor = tData.getCallerObj();

	// Add only the operators that apply as options
	var tOptions = tEditor.form.SubQueryColumn.options;

   var tColumnsXML = tData.getXML();
   
	var tColumns = tColumnsXML.selectSingleNode("//saw:columns");
	if (tColumns)
	{
	   XUICaptionSpace.addCaptions(tColumnsXML.selectSingleNode("//saw:captionSpace"));
	   XUIColumnSpace.addColumnsFromColumnSpace(tColumnsXML.selectSingleNode("//saw:columnSpace"));

	   var tColumn = saw.getFirstChildElement(tColumns);

	   while (tColumn)
	   {
	      var sColID = tColumn.getAttribute("columnID");
	      var sInfo = XUIColumnSpace.getHeadingFromColumn(tColumn, "saw:columnHeading");
	      var tNew = new Option(sInfo, sColID);
			tOptions[tOptions.length] = tNew;
			tNew.selected = (tEditor.columnID == sColID);
			tColumn = saw.getNextSiblingElement(tColumn);
	   }
	}

	// update the CatalogCaptionSpace so we display the localized name of the report
	var tCatalogCaptionSpace = tColumnsXML.selectSingleNode('//saw:catalogCaptionSpace');
      XUICatalogCaptionSpace.add(tCatalogCaptionSpace);
}
//-------------------
SubQueryFilterEditor.prototype.discard = function()
{
   if (this.creatingNewFilterCriteria == true)
   {
      this.creatingNewFilterCriteria = null;
      this.parentEditor.discard();
   }

   if (this.editingExistingFilterCriteria == true)
   {
      this.editingExistingFilterCriteria = null;
      this.parentEditor.discard();
   }
}